<?php
      $response = [];
      require_once "../configs.php";
      require_once "../functions/user_functions.php";
      $conn = connectDB();
      if($_SERVER["REQUEST_METHOD"] == "POST"){
        if(isset($_POST["action"]) && $_POST["action"] == "check_email"){

           $email = isset($_POST['email']) ? trim($_POST['email']) : '';

                // Validate email
                if (empty($email)) {
                    $response['error'] = true;
                    $response['message'] = "Email is required.";
                } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $response['message'] = 'Invalid email format.';
                    $response['error'] = true;
                } else {
                    // Check if email exists
                    $user = selectUserByEmail($conn, $email);

                    if ($user && is_array($user)) {
                        // Email exists
                        $response['isAvailable'] = false;
                        $response['error'] = false;
                    } else {
                        // Email not found → available
                        $response['isAvailable'] = true;
                        $response['message'] = 'Email is available.';
                        $response['error'] = false;
                    }
                }
            }
      }
      echo json_encode($response);

?>